﻿/*
VERSION:		1.4

WHAT IT HANDLES:
	Basic variables	(ie: string, number, boolean)
	Multidimensional Arrays
	Normal Objects
	BitmapData
	XMLNode
	
WHAT IT SKIPS:
	Functions
	Most Actionscript classes & components
	MovieClips
	
*/



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
function copyObject( srcObj, destObj )
{
	var showTrace = false;
	if(showTrace){trace("copyObject()")}
	for ( childName in srcObj )
	{
		if(showTrace){trace("")}
		if(showTrace){trace("childName: "+childName)}
		thisChild = srcObj[childName];
		childType = getType(thisChild);
		if(showTrace){trace(childName+":  "+childType)}
		
		// handle variables
		if (childType == "variable")
		{
			destObj[childName] = thisChild;
		}
		
		// handle pictures
		if (childType == "bitmap")
		{
			// // create new object
			destObj[childName] = thisChild.clone();
		}
		
		// handle XML
		if (childType == "xml")
		{
			// // create new object
			destObj[childName] = thisChild.cloneNode(true);
		}
		
		// handle Arrays
		if (childType == "array")
		{
			// // create new array
			destObj[childName] = new Array();
			// // set dest, scan array
			copyObject( thisChild, destObj[childName] );
		}
		
		// handle Objects
		if (childType == "object")
		{
			// // create new object
			destObj[childName] = new Object();
			// // set dest, scan object
			copyObject( thisChild, destObj[childName] );
		}
			
	}// END:  for...in
	
}



function getType( inputObject )
{
	var output = "";
	// unsupported objects to ignore
	if ( inputObject instanceof Function )
	{
		if(showTrace){trace("function")}
		// this is an array
		output = "function";
	}
	else if ( inputObject instanceof MovieClip )
	{
		if(showTrace){trace("movieClip")}
		// this is an array
		output = "movieClip";
	}
	
	// supported objects to handle
	else if ( inputObject instanceof Array )
	{
		if(showTrace){trace("array")}
		// this is an array
		output = "array";
	}
	else if ( inputObject instanceof BitmapData )
	{
		if(showTrace){trace("xml")}
		// this is an object
		output = "xml";
	}
	else if ( inputObject instanceof BitmapData )
	{
		if(showTrace){trace("bitmap")}
		// this is an object
		output = "bitmap";
	}
	else if ( inputObject instanceof Object )
	{
		if(showTrace){trace("object")}
		// this is an object
		output = "object";
	}
	else
	{
		// this is a regular variable
		if(showTrace){trace("variable")}
		output = "variable";
	}
	if(showTrace){trace("Object Type:  "+output)}
	return output;	// object, array, string, number, boolean
}



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 



function emptyObject( inputObject )
{
	for ( nam in inputObject )
	{
		delete inputObject[nam];
	}
}


